# accounts/forms.py

from django import forms
from django.contrib.auth.models import User
from helpers import apply_form_styling_and_validations  # Import the helper

class UserForm(forms.ModelForm):
    class Meta:
        model = User
        fields = ['username', 'email', 'is_active', 'is_staff']

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        apply_form_styling_and_validations(self)  # Call the helper function
