# enquiry/forms.py

from django import forms
from django.contrib.auth.models import User
from .models import Enquiry
from helpers import apply_form_styling_and_validations  # Import the helper

class EnquiryForm(forms.ModelForm):
    class Meta:
        model = Enquiry
        fields = ['name', 'email', 'contact', 'city','message']

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        apply_form_styling_and_validations(self)  # Call the helper function
