from django.db import models
from helpers import SoftDeleteModel
from master.models import City


class Enquiry(SoftDeleteModel):
    name = models.CharField(max_length=100)
    email = models.EmailField()
    contact = models.CharField(max_length=15)
    city = models.CharField(max_length=15, null=True, blank=True)
    message = models.TextField()
    
    created_at = models.DateTimeField(auto_now_add=True)  # optional for tracking
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return f"Enquiry from {self.name} ({self.email})"


class ReferralSource(models.TextChoices):
    FRIEND = 'Friend', 'Friend'
    REFERENCE = 'Reference', 'Reference'
    SOCIAL_MEDIA = 'Social Media', 'Social Media'
    OTHERS = 'Others', 'Others'

class CareerEnquiry(SoftDeleteModel):
    name = models.CharField(max_length=100)
    email = models.EmailField()
    contact = models.CharField(max_length=15)
    position = models.ForeignKey(City,on_delete=models.CASCADE, null=True , blank=True)
    resume = models.FileField(null=True,blank=True,upload_to="resumes")

    refer_from = models.CharField(
        max_length=20,
        choices=ReferralSource.choices,
        default=ReferralSource.OTHERS,
        verbose_name="How did you hear about us?"
    )

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return f"Enquiry from {self.name} ({self.email})"
    
