# enquiry/urls.py

from django.urls import path
from .views import (
    EnquiryListView, EnquiryCreateView, EnquiryUpdateView, EnquiryDeleteView,
    CareerListView, CareerCreateView, CareerUpdateView, CareerDeleteView
)

app_name = 'enquiry'

urlpatterns = [
    # Form Enquiries
    path('', EnquiryListView.as_view(), name='enquiry_list'),
    path('add/', EnquiryCreateView.as_view(), name='enquiry_add'),
    path('<int:pk>/edit/', EnquiryUpdateView.as_view(), name='enquiry_edit'),
    path('<int:pk>/delete/', EnquiryDeleteView.as_view(), name='enquiry_delete'),

    # Career Enquiries
    path('career/', CareerListView.as_view(), name='career_list'),
    path('career/add/', CareerCreateView.as_view(), name='career_add'),
    path('career/<int:pk>/edit/', CareerUpdateView.as_view(), name='career_edit'),
    path('career/<int:pk>/delete/', CareerDeleteView.as_view(), name='career_delete'),
]
