from django.urls import path
from .views import CityListView, CityCreateView, CityUpdateView, CityDeleteView

app_name = 'city'

urlpatterns = [
    path('city', CityListView.as_view(), name='city_list'),
    path('city/add/', CityCreateView.as_view(), name='city_add'),
    path('city/<int:pk>/edit/', CityUpdateView.as_view(), name='city_edit'),
    path('city/<int:pk>/delete/', CityDeleteView.as_view(), name='city_delete'),
]
